/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.build;

import com.aptana.buildpath.core.BuildPathCorePlugin;
import com.aptana.buildpath.core.BuildPathManager;
import com.aptana.buildpath.core.IBuildPathEntry;
import com.aptana.core.CorePlugin;
import com.aptana.core.IFilter;
import com.aptana.core.IMap;
import com.aptana.core.build.IBuildParticipant;
import com.aptana.core.build.IBuildParticipantManager;
import com.aptana.core.build.IProblem;
import com.aptana.core.build.Messages;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ResourceUtil;
import com.aptana.index.core.FileStoreBuildContext;
import com.aptana.index.core.IIndexFileContributor;
import com.aptana.index.core.IndexContainerJob;
import com.aptana.index.core.IndexFileJob;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.build.BuildContext;
import com.aptana.index.core.filter.IIndexFilterParticipant;
import com.aptana.parsing.ParserPoolFactory;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnifiedBuilder
extends IncrementalProjectBuilder {
    public static final String ID = "com.aptana.ide.core.unifiedBuilder";
    private boolean traceParticipantsEnabled = false;

    private static void removeProblemsAndTasksFor(IResource resource) {
        try {
            if (resource != null && resource.isAccessible()) {
                resource.deleteMarkers("com.aptana.core.problem", true, 2);
                resource.deleteMarkers("com.aptana.core.task", true, 2);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        super.clean(monitor);
        IProject project = this.getProjectHandle();
        IBuildParticipantManager manager = this.getBuildParticipantManager();
        if (manager == null) {
            return;
        }
        List<IBuildParticipant> participants = manager.getAllBuildParticipants();
        participants = this.filterToEnabled(participants, project);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(participants.size() + 2));
        sub.worked(1);
        ParserPoolFactory.getInstance().clearCache();
        UnifiedBuilder.removeProblemsAndTasksFor((IResource)project);
        sub.worked(1);
        for (IBuildParticipant participant : participants) {
            if (sub.isCanceled()) {
                return;
            }
            participant.clean(project, (IProgressMonitor)sub.newChild(1));
        }
        sub.done();
    }

    private List<IBuildParticipant> filterToEnabled(List<IBuildParticipant> participants, final IProject project) {
        return CollectionsUtil.filter(participants, (IFilter)new IFilter<IBuildParticipant>(){

            public boolean include(IBuildParticipant item) {
                try {
                    return item != null && item.isEnabled(project) && item.isEnabled(IBuildParticipant.BuildType.BUILD);
                }
                catch (Exception e) {
                    IdeLog.logWarning((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
                    return false;
                }
            }
        });
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        this.traceParticipantsEnabled = IdeLog.isTraceEnabled((Plugin)BuildPathCorePlugin.getDefault(), (String)"com.aptana.core/debug/builder/participants");
        boolean logTraceEnabled = this.traceLoggingEnabled();
        IProject project = this.getProjectHandle();
        String projectName = project.getName();
        long startTime = System.nanoTime();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IBuildParticipantManager manager = this.getBuildParticipantManager();
        if (manager == null) {
            return new IProject[0];
        }
        List<IBuildParticipant> participants = manager.getAllBuildParticipants();
        participants = this.filterToEnabled(participants, project);
        this.buildStarting(participants, kind, (IProgressMonitor)sub.newChild(10));
        if (kind == 6) {
            if (logTraceEnabled) {
                UnifiedBuilder.logTrace(MessageFormat.format(Messages.UnifiedBuilder_PerformingFullBuld, projectName));
            }
            this.fullBuild(participants, (IProgressMonitor)sub.newChild(80));
        } else {
            IResourceDelta delta = this.getResourceDelta();
            if (delta == null) {
                if (logTraceEnabled) {
                    UnifiedBuilder.logTrace(MessageFormat.format(Messages.UnifiedBuilder_PerformingFullBuildNullDelta, projectName));
                }
                this.fullBuild(participants, (IProgressMonitor)sub.newChild(80));
            } else {
                if (logTraceEnabled) {
                    UnifiedBuilder.logTrace(MessageFormat.format(Messages.UnifiedBuilder_PerformingIncrementalBuild, projectName));
                }
                this.incrementalBuild(participants, delta, (IProgressMonitor)sub.newChild(80));
            }
        }
        this.buildEnding(participants, (IProgressMonitor)sub.newChild(10));
        if (logTraceEnabled) {
            double endTime = ((double)System.nanoTime() - (double)startTime) / 1000000.0;
            UnifiedBuilder.logTrace(MessageFormat.format(Messages.UnifiedBuilder_FinishedBuild, projectName, endTime));
        }
        return null;
    }

    protected boolean traceLoggingEnabled() {
        return IdeLog.isTraceEnabled((Plugin)CorePlugin.getDefault(), (String)"com.aptana.core/debug/builder");
    }

    private static void logTrace(String msg) {
        IdeLog.logInfo((Plugin)CorePlugin.getDefault(), (String)msg, (String)"com.aptana.core/debug/builder");
    }

    private void buildEnding(List<IBuildParticipant> participants, IProgressMonitor monitor) {
        if (participants == null) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)participants.size());
        for (IBuildParticipant participant : participants) {
            participant.buildEnding((IProgressMonitor)sub.newChild(1));
        }
        sub.done();
    }

    private void buildStarting(List<IBuildParticipant> participants, int kind, IProgressMonitor monitor) {
        if (CollectionsUtil.isEmpty(participants)) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)participants.size());
        for (IBuildParticipant participant : participants) {
            participant.buildStarting(this.getProjectHandle(), kind, (IProgressMonitor)sub.newChild(1));
        }
        sub.done();
    }

    private void incrementalBuild(List<IBuildParticipant> participants, IResourceDelta delta, IProgressMonitor monitor) {
        try {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            ResourceCollector collector = new ResourceCollector();
            delta.accept((IResourceDeltaVisitor)collector);
            this.indexProjectBuildPaths((IProgressMonitor)sub.newChild(25));
            this.removeFiles(participants, collector.removedFiles, (IProgressMonitor)sub.newChild(5));
            this.buildFiles(participants, collector.updatedFiles, (IProgressMonitor)sub.newChild(70));
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
        }
    }

    private void removeFiles(List<IBuildParticipant> participants, Set<IFile> filesToRemoveFromIndex, IProgressMonitor monitor) throws CoreException {
        if (CollectionsUtil.isEmpty(filesToRemoveFromIndex)) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(16 * filesToRemoveFromIndex.size()));
        for (IFile file : filesToRemoveFromIndex) {
            BuildContext context = new BuildContext(file);
            sub.worked(1);
            IBuildParticipantManager manager = this.getBuildParticipantManager();
            if (manager == null) {
                return;
            }
            List<IBuildParticipant> filteredParticipants = manager.filterParticipants(participants, context.getContentType());
            sub.worked(5);
            this.deleteFile(context, filteredParticipants, (IProgressMonitor)sub.newChild(10));
        }
        sub.done();
    }

    private void deleteFile(BuildContext context, List<IBuildParticipant> participants, IProgressMonitor monitor) {
        if (CollectionsUtil.isEmpty(participants)) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)participants.size());
        for (IBuildParticipant participant : participants) {
            participant.deleteFile(context, (IProgressMonitor)sub.newChild(1));
        }
        sub.done();
    }

    protected IBuildParticipantManager getBuildParticipantManager() {
        BuildPathCorePlugin plugin = BuildPathCorePlugin.getDefault();
        return plugin == null ? null : plugin.getBuildParticipantManager();
    }

    private void fullBuild(List<IBuildParticipant> participants, IProgressMonitor monitor) throws CoreException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.indexProjectBuildPaths((IProgressMonitor)sub.newChild(50));
        IProject project = this.getProjectHandle();
        URI uri = project.getLocationURI();
        Set<IFileStore> contributedFiles = this.getContributedFiles(uri);
        sub.worked(2);
        this.buildContributedFiles(participants, contributedFiles, (IProgressMonitor)sub.newChild(6));
        CollectingResourceVisitor visitor = new CollectingResourceVisitor();
        project.accept((IResourceVisitor)visitor);
        visitor.files.trimToSize();
        sub.worked(2);
        this.buildFiles(participants, visitor.files, (IProgressMonitor)sub.newChild(40));
        sub.done();
    }

    private void indexProjectBuildPaths(IProgressMonitor monitor) {
        IProject project = this.getProjectHandle();
        Set<IBuildPathEntry> entries = this.getBuildPathManager().getBuildPaths(project);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)entries.size());
        for (IBuildPathEntry entry : entries) {
            try {
                IFileStore fileStore = EFS.getStore((URI)entry.getPath());
                if (fileStore == null) continue;
                if (fileStore.fetchInfo().isDirectory()) {
                    new IndexContainerJob(entry.getDisplayName(), entry.getPath()).run((IProgressMonitor)sub.newChild(1));
                    continue;
                }
                new IndexFileJob(entry.getDisplayName(), entry.getPath()).run((IProgressMonitor)sub.newChild(1));
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
            }
        }
    }

    protected BuildPathManager getBuildPathManager() {
        return BuildPathManager.getInstance();
    }

    private void buildContributedFiles(List<IBuildParticipant> participants, Set<IFileStore> files, IProgressMonitor monitor) throws CoreException {
        if (CollectionsUtil.isEmpty(files)) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(15 * files.size()));
        IProject project = this.getProjectHandle();
        for (IFileStore file : files) {
            FileStoreBuildContext context = new FileStoreBuildContext(project, file);
            sub.worked(1);
            IBuildParticipantManager manager = this.getBuildParticipantManager();
            if (manager == null) {
                return;
            }
            List<IBuildParticipant> filteredParticipants = manager.filterParticipants(participants, context.getContentType());
            sub.worked(2);
            this.buildFile((BuildContext)context, filteredParticipants, (IProgressMonitor)sub.newChild(12));
            if (sub.isCanceled()) break;
        }
        sub.done();
    }

    protected Set<IFileStore> getContributedFiles(URI container) {
        HashSet<IFileStore> result = new HashSet<IFileStore>();
        IndexManager manager = this.getIndexManager();
        if (manager != null) {
            for (IIndexFileContributor contributor : manager.getFileContributors()) {
                Set files = contributor.getFiles(container);
                if (CollectionsUtil.isEmpty((Collection)files)) continue;
                result.addAll(files);
            }
        }
        return result;
    }

    protected IndexManager getIndexManager() {
        IndexPlugin plugin = IndexPlugin.getDefault();
        return plugin == null ? null : plugin.getIndexManager();
    }

    protected IProject getProjectHandle() {
        return this.getProject();
    }

    protected IResourceDelta getResourceDelta() {
        return this.getDelta(this.getProjectHandle());
    }

    private void buildFiles(List<IBuildParticipant> participants, Collection<IFile> files, IProgressMonitor monitor) throws CoreException {
        if (CollectionsUtil.isEmpty(participants) || CollectionsUtil.isEmpty(files)) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        files = this.filterFiles(files, (IProgressMonitor)sub.newChild(10));
        this.doBuildFiles(participants, files, (IProgressMonitor)sub.newChild(90));
        sub.done();
    }

    private void doBuildFiles(List<IBuildParticipant> participants, Collection<IFile> files, IProgressMonitor monitor) throws CoreException {
        if (CollectionsUtil.isEmpty(files)) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(15 * files.size()));
        for (IFile file : files) {
            BuildContext context = new BuildContext(file);
            sub.worked(1);
            IBuildParticipantManager manager = this.getBuildParticipantManager();
            if (manager == null) {
                return;
            }
            List<IBuildParticipant> filteredParticipants = manager.filterParticipants(participants, context.getContentType());
            sub.worked(2);
            this.buildFile(context, filteredParticipants, (IProgressMonitor)sub.newChild(12));
            if (sub.isCanceled()) break;
        }
        sub.done();
    }

    private Collection<IFile> filterFiles(Collection<IFile> files, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        files = CollectionsUtil.filter(files, (IFilter)new IFilter<IFile>(){

            public boolean include(IFile item) {
                return !ResourceUtil.shouldIgnore((IFile)item);
            }
        });
        sub.worked(10);
        Set fileStores = new HashSet(CollectionsUtil.map((Collection)files, (IMap)new IMap<IFile, IFileStore>(){

            public IFileStore map(IFile item) {
                IPath path = item.getLocation();
                return path == null ? null : EFS.getLocalFileSystem().getStore(path);
            }
        }));
        sub.worked(15);
        if (!CollectionsUtil.isEmpty(fileStores)) {
            IndexManager manager = this.getIndexManager();
            if (manager != null) {
                for (IIndexFilterParticipant filterParticipant : manager.getFilterParticipants()) {
                    fileStores = filterParticipant.applyFilter(fileStores);
                }
            }
            sub.worked(60);
            return CollectionsUtil.map(fileStores, (IMap)new IMap<IFileStore, IFile>(){

                public IFile map(IFileStore fileStore) {
                    IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    Object[] iFiles = workspaceRoot.findFilesForLocationURI(fileStore.toURI());
                    if (ArrayUtil.isEmpty((Object[])iFiles)) {
                        return null;
                    }
                    return iFiles[0];
                }
            });
        }
        return files;
    }

    private void buildFile(BuildContext context, List<IBuildParticipant> participants, IProgressMonitor monitor) throws CoreException {
        if (CollectionsUtil.isEmpty(participants)) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 * participants.size()));
        for (IBuildParticipant participant : participants) {
            long startTime = System.nanoTime();
            participant.buildFile(context, (IProgressMonitor)sub.newChild(1));
            if (this.traceParticipantsEnabled) {
                double endTime = ((double)System.nanoTime() - (double)startTime) / 1000000.0;
                IdeLog.logTrace((Plugin)BuildPathCorePlugin.getDefault(), (String)MessageFormat.format("Executed build participant ''{0}'' on ''{1}'' in {2} ms.", participant.getName(), context.getURI(), endTime), (String)"com.aptana.core/debug/builder/participants");
            }
            if (sub.isCanceled()) break;
        }
        this.updateMarkers(context, (IProgressMonitor)sub.newChild(participants.size()));
        sub.done();
    }

    private void updateMarkers(BuildContext context, IProgressMonitor monitor) {
        final IFile file = context.getFile();
        final Map itemsByType = context.getProblems();
        if (CollectionsUtil.isEmpty((Map)itemsByType)) {
            return;
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) {
                UnifiedBuilder.this.updateMarkers(file, itemsByType, monitor);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, UnifiedBuilder.getMarkerRule(file), 1, monitor);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (String)"Error updating markers", (Throwable)e);
        }
    }

    private static ISchedulingRule getMarkerRule(Object resource) {
        if (resource instanceof IResource) {
            return ResourcesPlugin.getWorkspace().getRuleFactory().markerRule((IResource)resource);
        }
        return null;
    }

    private synchronized void updateMarkers(IFile file, Map<String, Collection<IProblem>> itemsByType, IProgressMonitor monitor) {
        if (!file.exists()) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(itemsByType.size() * 10));
        for (String markerType : itemsByType.keySet()) {
            try {
                Collection<IProblem> newItems = itemsByType.get(markerType);
                file.deleteMarkers(markerType, false, 2);
                sub.worked(1);
                this.addMarkers(newItems, markerType, file, (IProgressMonitor)sub.newChild(9));
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
            }
        }
        sub.done();
    }

    private void addMarkers(Collection<IProblem> items, String markerType, IFile file, IProgressMonitor monitor) throws CoreException {
        if (CollectionsUtil.isEmpty(items)) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(items.size() * 2));
        for (IProblem item : items) {
            IMarker marker = file.createMarker(markerType);
            sub.worked(1);
            marker.setAttributes(item.createMarkerAttributes());
            sub.worked(1);
        }
        sub.done();
    }

    private static class CollectingResourceVisitor
    implements IResourceVisitor {
        ArrayList<IFile> files = new ArrayList();

        private CollectingResourceVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (1 == resource.getType()) {
                this.files.add((IFile)resource);
                return false;
            }
            return true;
        }
    }

    private static class ResourceCollector
    implements IResourceDeltaVisitor {
        Set<IFile> updatedFiles = new HashSet<IFile>();
        Set<IFile> removedFiles = new HashSet<IFile>();

        private ResourceCollector() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource instanceof IFile) {
                if (delta.getKind() == 1 || delta.getKind() == 4 && (delta.getFlags() & 0x100100) != 0) {
                    this.updatedFiles.add((IFile)resource);
                } else if (delta.getKind() == 2) {
                    this.removedFiles.add((IFile)resource);
                }
            }
            return true;
        }
    }
}

